//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_NameChannel    "Demo"
//+------------------------------------------------------------------+
int OnInit()
{
   ObjectCreate(0, def_NameChannel, OBJ_TREND, 0, 0, 0);
   ObjectSetInteger(0, def_NameChannel, OBJPROP_COLOR, clrLawnGreen);
   ObjectSetInteger(0, def_NameChannel, OBJPROP_WIDTH, 4);

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const datetime &Time[], const double &Open[], const double &High[], const double &Low[], const double &Close[], const long &TickVolume[], const long &Volume[], const int &Spread[])
{
    const int   n = 60;
    double      p = DBL_MIN;
    int         t = 0;

    for (int c = rates_total - (n + 1); c < rates_total; c++)
        p = (High[c] > p ? High[t = c] : p);
    ObjectMove(0, def_NameChannel, 0, Time[t], p);
    p = DBL_MIN;
    for (int c = t + 1; c < rates_total; c++)
        p = ((High[c] > p) && (Open[c] < Close[c]) ? High[t = c] : p);
    ObjectMove(0, def_NameChannel, 1, Time[t], p);

   return rates_total;
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   ObjectDelete(0, def_NameChannel);
   ChartRedraw();
};
//+------------------------------------------------------------------+